IF EXISTS (SELECT * FROM SYS.COLUMNS WHERE NAME = 'TIPO_IMPOSTO' AND OBJECT_ID = OBJECT_ID('PDV_MAPA_RESUMO_CPL'))
BEGIN
	ALTER TABLE [PDV_MAPA_RESUMO_CPL] ALTER COLUMN [TIPO_IMPOSTO] numeric(5,1) NOT NULL;
END

IF EXISTS (SELECT Col.Column_Name from 
    INFORMATION_SCHEMA.TABLE_CONSTRAINTS Tab, 
    INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE Col 
WHERE 
    Col.Constraint_Name = Tab.Constraint_Name
    AND Col.Table_Name = Tab.Table_Name
    AND Constraint_Type = 'PRIMARY KEY'
    AND Col.Table_Name = 'PDV_MAPA_RESUMO_CPL')
	
	BEGIN
	
		ALTER TABLE [dbo].[PDV_MAPA_RESUMO_CPL] DROP CONSTRAINT [PK_PDV_MAPA_RESUMO_CPL];
		
		ALTER TABLE [dbo].[PDV_MAPA_RESUMO_CPL] ADD  CONSTRAINT [PK_PDV_MAPA_RESUMO_CPL] PRIMARY KEY CLUSTERED 
		(
			[CD_EMP] ASC,
			[CD_FILIAL] ASC,
			[CD_CTR] ASC,
			[TX_ICMS] ASC,
			[TIPO_IMPOSTO] ASC
		)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]

	END